var config = {
    exam_type:"",
    //demo盘类型：
    //SINGLE_EXAM => 一份试卷
    //MULTIPLE_EXAM => 多份试卷
    form_id:"",//试卷id
    exam_title:""//考试名称
};
// 打开练习
function startTest(name) {
    window.API.startTest({
        form_path: './forms/' + name,        
        skin_path: './skins/demo.skin'
    }).catch( function(err){
        window.API.showErrorBox('', err.message)
    });
}

// 退出
function quit() {
    window.API.quit();
}

//加载试卷列表
function loadPapers(){
    var forms = window.API.forms;
    //var forms = [{name:"1", title:"2"}];
    var s = "";
    if(forms.length >1){
        config.exam_type = "MULTIPLE_EXAM";
        forms.forEach(function(p){
            s += "<li class='item' paper_id='"+p.name+"'><span class='exam-title'>"+p.title+"</span></li>";
        });
        $("#content").html(s);
        $(".choose-select").html(forms[0].title);
        $(".choose-select").attr("exam_id",forms[0].name)
    }else{
        config.exam_type = "SINGLE_EXAM";
        config.form_id = forms[0].name;
        config.exam_title = forms[0].title;
    }
    selectClickFun();
}
//li hover 事件
function bindSelectHoverFun(){
    $(".item").mouseover(function(){
        $(this).addClass("select-item-hover")
    }).mouseout(function(){
        $(this).removeClass("select-item-hover")
    })
}
//动作条美化
function niceSrollFun(){
    $('#content').niceScroll({
        cursorcolor: "#000000",//滚动条的颜色
        cursoropacitymax: 0.5, //滚动条的透明度，从0-1
        touchbehavior: false, //使光标拖动滚动像在台式电脑触摸设备
        cursorwidth: "5px", //滚动条的宽度
        cursorborder: "0", // 游标边框css定义
        cursorborderradius: "5px",//以像素为光标边界半径  圆角
        autohidemode: false, //是否隐藏滚动条  true的时候默认不显示滚动条，当鼠标经过的时候显示滚动条
        zindex:"auto",//给滚动条设置z-index值
        railpadding: { top:0, right:0, left:0, bottom:0 }//滚动条的位置
    });
}
//初始化列表toggle事件
function selectClickFun(){
    $("#select_btn").click(function(){
        $(".select-view,.select-list,.arrow-tag").toggle(0)
    })
}
//点击赋值函数
function clickItemFun(){
    $(".item").click(function(){
        $(".choose-select").html($(this).find(".exam-title").html());
        $(".choose-select").attr("exam_id",$(this).attr("paper_id"))
    })
}
//绑定事件函数
function bindClickFun(){
    clickItemFun();
    $(".btn-start").click(function(){
        if(config.exam_type == "SINGLE_EXAM"){
            startTest(config.form_id);
        }else{
            startTest($(".choose-select").attr("exam_id"));
        }
    });
    $(".btn-exit").click(function(){
        quit();
    });
}
function init(){
    loadPapers();
    if(config.exam_type == "SINGLE_EXAM"){
        $(".head-title").show().html(config.exam_title);
    }else{
        $(".select").show();
        bindSelectHoverFun();
        niceSrollFun();
    }
    bindClickFun();
}

$(function(){
    init()
});
